﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/private/Private.Master" CodeBehind="Configuracion.aspx.vb" Inherits="Web.Configuracion" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <asp:UpdatePanel runat="server" ID="UpdatePanelRegistration" UpdateMode="Conditional">
        <ContentTemplate>

            <div class="block private">
                <div class="add-panel">
                    <div class="container newpanels">
                        <h2><%= Translator.Translate("ADMIN_CONFIGURATION")%></h2>
                    </div>
                </div>
                <div class="content ajax-tabs">

                    <div class="reg-form" runat="server" id="DivCamps">

                        <fieldset>
                            <div class="row private header" runat="server" id="divGeneralConfiguration" visible="false">
                                <span class="label" style="min-width: 300px !important;"><%= Translator.Translate("ADMIN_MENU_CONFIG")%> </span>
                            </div>
                            <div class="row private" runat="server" id="divLanguage" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_LANGUAGE")%> </span>
                                <asp:DropDownList ID="lnLanguage" runat="server" CssClass="input">
                                </asp:DropDownList>
                            </div>
                            <div class="row private" runat="server" id="divTimeoutUpdateSetControl" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_TIMEOUT_UPDATE_SETCONTROL")%> </span>
                                <asp:TextBox ID="TimeoutUpdateSetControl" ValidationGroup="Configuracion" runat="server" CssClass="input" Width="100px" Style="text-align: right !important;"></asp:TextBox>
                                <ajaxToolkit:FilteredTextBoxExtender ID="FilteredTextBoxExtender2" runat="server" TargetControlID="TimeoutUpdateSetControl" ValidChars="1234567890" />
                                <asp:RangeValidator ID="RangeValidator2" ControlToValidate="TimeoutUpdateSetControl" MinimumValue="0" MaximumValue="999999999" Type="Integer" Text="" runat="server"></asp:RangeValidator>
                            </div>
                            <div class="row private" runat="server" id="divTimeoutDiscovery" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_TIMEOUT_DISCOVERY")%> </span>
                                <asp:TextBox ID="TimeoutDiscovery" ValidationGroup="Configuracion" runat="server" CssClass="input" Style="text-align: right !important;" Width="100px"></asp:TextBox>
                                <ajaxToolkit:FilteredTextBoxExtender ID="FilteredTextBoxExtender3" runat="server" TargetControlID="TimeoutDiscovery" ValidChars="1234567890" />
                                <asp:RangeValidator ID="RangeValidator3" ControlToValidate="TimeoutDiscovery" MinimumValue="0" MaximumValue="999999999" Type="Integer" Text="" runat="server"></asp:RangeValidator>
                            </div>
                            <div class="row private" runat="server" id="divUriHostController" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_URI_HOST_CONTROLLER")%> </span>
                                <asp:TextBox ID="UriHostController" runat="server" CssClass="input"></asp:TextBox>
                            </div>
                            <div class="row private" runat="server" id="divUriGestureController" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_URI_GESTURE_CONTROLLER")%> </span>
                                <asp:TextBox ID="UriGestureController" runat="server" CssClass="input"></asp:TextBox>
                            </div>
                            <div class="row private" runat="server" id="divGestureRecognitionActive" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_GESTURE_ACTIVE")%> </span>
                                <asp:DropDownList ID="GestureRecognitionActive" runat="server" CssClass="input">
                                    <asp:ListItem Text="NO" Value="NO"></asp:ListItem>
                                    <asp:ListItem Text="YES" Value="YES"></asp:ListItem>
                                </asp:DropDownList>
                            </div>
                            <div class="row private" runat="server" id="divActiveDirectoryUrl" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_LDAP_URL")%> </span>
                                <asp:TextBox ID="ActiveDirectoryUrl" runat="server" CssClass="input"></asp:TextBox>
                            </div>
                            <div class="row private" runat="server" id="divCustomLdapGroup" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_LDAP_CUSTOM_PATH")%> </span>
                                <asp:TextBox ID="CustomLdapGroup" runat="server" CssClass="input"></asp:TextBox>
                            </div>
                            <div class="row private" runat="server" id="divUseActiveDirectoryAuthentication" visible="false">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_LDAP_ACTIVE")%> </span>
                                <asp:DropDownList ID="UseActiveDirectoryAuthentication" runat="server" CssClass="input">
                                    <asp:ListItem Text="NO" Value="NO"></asp:ListItem>
                                    <asp:ListItem Text="YES" Value="YES"></asp:ListItem>
                                </asp:DropDownList>
                            </div>
                            <div class="row private header">
                                <span class="label"><%= Translator.Translate("MSG_INSTALL_WIZARD_TEXTDATMAIL")%> </span>
                            </div>
                            <div class="row private">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_MAIL_SMTP")%> </span>
                                <asp:TextBox ID="TbMailSmtp" runat="server" CssClass="input" AutoPostBack="true" OnTextChanged="TbMailSmtp_TextChanged"></asp:TextBox>
                            </div>
                            <div class="row private">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_MAIL_PORT")%> </span>
                                <asp:TextBox ID="TbMailPort" runat="server" MaxLength="5" CssClass="input" Style="text-align: right !important;" Width="100px"></asp:TextBox>
                                <ajaxToolkit:FilteredTextBoxExtender ID="RegNumMailPort" runat="server" TargetControlID="TbMailPort" ValidChars="1234567890" />
                                <asp:RangeValidator ID="RqValPort" ControlToValidate="TbMailPort" MinimumValue="1" MaximumValue="65535" ForeColor="#ff6666" Font-Bold="true" Type="Integer" Text="" runat="server"></asp:RangeValidator>
                            </div>
                            <div class="row private">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_MAIL_USER")%> </span>
                                <asp:TextBox ID="TbMailUser" runat="server" CssClass="input" Text=""></asp:TextBox>
                            </div>
                            <div class="row private">
                                <span class="label"><%= Translator.Translate("ADMIN_CONFIG_MAIL_USER_PASSWORD")%> </span>
                                <asp:TextBox ID="TbMailUserPassword" ValidationGroup="Configuracion" runat="server" CssClass="input"></asp:TextBox>
                            </div>
                            <div class="row">
                                <br />
                                <asp:Button ID="btnGuardar" runat="server" CssClass="btn" OnClick="btnGuardar_Click" />
                                <a id="btnCancelar" class="btn" style="float: right;" href="../../home.aspx"><%= Translator.Translate("ADMIN_BTN_CANCEL") %></a>
                            </div>
                            <div class="row">
                                <br />
                            </div>
                        </fieldset>

                        <!-- controles ocultos-->
                        <asp:HiddenField ID="IdCliente" runat="server" />
                        <asp:HiddenField ID="FechaActivacion" runat="server" />
                        <asp:HiddenField ID="FechaUltimaConexion" runat="server" Value="#null#" />

                    </div>

                    <!--Panel de errores del formulario de registro -->
                    <asp:Panel ID="PanelErrores" runat="server" Style="display: none" CssClass="error-message">
                        <div class="holder">
                            <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
                            <asp:Button ID="btnAceptar_Esborrar" runat="server" Visible="false" />
                            <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn"></a>
                        </div>
                    </asp:Panel>

                </div>

            </div>

            <!-- controles ajax-->
            <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID="" />

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnPanelErrores" runat="server" />

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="btnGuardar" EventName="Click" />
            <%--<asp:AsyncPostBackTrigger ControlID="btnCancelar" EventName="Click" />--%>
        </Triggers>
    </asp:UpdatePanel>
    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderRegistration" TargetControlID="UpdatePanelRegistration" BehaviorID="animation" runat="server">
        <Animations>    
            <OnUpdated>
                <Sequence>
                    <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
                    <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
                    <ScriptAction Script="initRefreshFunctions();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

</asp:Content>

